/**
 * Controls the notification area on the notification page.
 *
 * @module     message_popup/notification_area_control_area
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("message_popup/notification_area_control_area",["jquery","core/templates","core/notification","core/custom_interaction_events","message_popup/notification_repository","message_popup/notification_area_events"],(function($,Templates,DebugNotification,CustomEvents,NotificationRepo,NotificationAreaEvents){var SELECTORS_CONTAINER='[data-region="notification-area"]',SELECTORS_CONTENT='[data-region="content"]',SELECTORS_NOTIFICATION='[data-region="notification-content-item-container"]',SELECTORS_CAN_RECEIVE_FOCUS='input:not([type="hidden"]), a[href], button, textarea, select, [tabindex]',TEMPLATES_NOTIFICATION="message_popup/notification_content_item",ControlArea=function(root,userId){this.root=$(root),this.container=this.root.closest(SELECTORS_CONTAINER),this.userId=userId,this.content=this.root.find(SELECTORS_CONTENT),this.offset=0,this.limit=20,this.initialLoad=!1,this.isLoading=!1,this.loadedAll=!1,this.notifications={},this.registerEventListeners()};return ControlArea.prototype.getRoot=function(){return this.root},ControlArea.prototype.getContainer=function(){return this.container},ControlArea.prototype.getUserId=function(){return this.userId},ControlArea.prototype.getContent=function(){return this.content},ControlArea.prototype.getOffset=function(){return this.offset},ControlArea.prototype.getLimit=function(){return this.limit},ControlArea.prototype.setOffset=function(value){this.offset=value},ControlArea.prototype.setLimit=function(value){this.limit=value},ControlArea.prototype.incrementOffset=function(){this.offset+=this.limit},ControlArea.prototype.startLoading=function(){this.isLoading=!0,this.getRoot().addClass("loading")},ControlArea.prototype.stopLoading=function(){this.isLoading=!1,this.getRoot().removeClass("loading")},ControlArea.prototype.hasDoneInitialLoad=function(){return this.initialLoad},ControlArea.prototype.hasLoadedAllContent=function(){return this.loadedAll},ControlArea.prototype.setLoadedAllContent=function(val){this.loadedAll=val},ControlArea.prototype.setCacheNotification=function(notification){this.notifications[notification.id]=notification},ControlArea.prototype.getCacheNotification=function(id){return this.notifications[id]},ControlArea.prototype.getNotificationElement=function(id){var element=this.getRoot().find(SELECTORS_NOTIFICATION+'[data-id="'+id+'"]');return 1==element.length?element:null},ControlArea.prototype.scrollNotificationIntoView=function(notificationElement){var position=notificationElement.position(),container=this.getRoot();if(position.top-container.scrollTop()>container.innerHeight()){var height=notificationElement.outerHeight();height*=4;var scrollTo=position.top-height;container.scrollTop(scrollTo)}},ControlArea.prototype.showNotification=function(notificationElement){if("object"!=typeof notificationElement&&(notificationElement=this.getNotificationElement(notificationElement)),notificationElement&&notificationElement.length){this.getRoot().find(SELECTORS_NOTIFICATION).removeClass("selected"),notificationElement.addClass("selected").find(SELECTORS_CAN_RECEIVE_FOCUS).focus();var notificationId=notificationElement.attr("data-id"),notification=this.getCacheNotification(notificationId);this.scrollNotificationIntoView(notificationElement),this.getContainer().trigger(NotificationAreaEvents.showNotification,[$.extend({},notification)])}},ControlArea.prototype.markNotificationAsRead=function(notificationElement){return NotificationRepo.markAsRead(notificationElement.attr("data-id")).done((function(){notificationElement.removeClass("unread")}))},ControlArea.prototype.renderNotifications=function(notifications){var promises=[],container=this.getContent();return $.each(notifications,function(index,notification){var contextUrl=notification.contexturl;delete notification.contexturl;var promise=Templates.render(TEMPLATES_NOTIFICATION,notification).then(function(html,js){return notification.contexturl=contextUrl,this.setCacheNotification(notification),{html:html,js:js}}.bind(this));promises.push(promise)}.bind(this)),$.when.apply($,promises).then((function(){$.each(arguments,(function(index,argument){container.append(argument.html),Templates.runTemplateJS(argument.js)}))}))},ControlArea.prototype.loadMoreNotifications=function(){if(this.isLoading||this.hasLoadedAllContent())return $.Deferred().resolve();this.startLoading();var request={limit:this.getLimit(),offset:this.getOffset(),useridto:this.getUserId()};return this.initialLoad||(request.limit=this.getOffset()+this.getLimit(),request.offset=0),NotificationRepo.query(request).then(function(result){var notifications=result.notifications;return this.unreadCount=result.unreadcount,this.setLoadedAllContent(!notifications.length||notifications.length<this.getLimit()),this.initialLoad=!0,!!notifications.length&&(this.incrementOffset(),this.renderNotifications(notifications))}.bind(this)).always(function(){this.stopLoading()}.bind(this))},ControlArea.prototype.registerEventListeners=function(){CustomEvents.define(this.getRoot(),[CustomEvents.events.activate,CustomEvents.events.scrollBottom,CustomEvents.events.scrollLock,CustomEvents.events.up,CustomEvents.events.down]),this.getRoot().on(CustomEvents.events.scrollBottom,function(){this.loadMoreNotifications()}.bind(this)),this.getRoot().on(CustomEvents.events.activate,SELECTORS_NOTIFICATION,function(e){var notificationElement=$(e.target).closest(SELECTORS_NOTIFICATION);this.showNotification(notificationElement)}.bind(this)),this.getRoot().on(CustomEvents.events.up,SELECTORS_NOTIFICATION,function(e,data){var notificationElement=$(e.target).closest(SELECTORS_NOTIFICATION);this.showNotification(notificationElement.prev()),data.originalEvent.preventDefault()}.bind(this)),this.getRoot().on(CustomEvents.events.down,SELECTORS_NOTIFICATION,function(e,data){var notificationElement=$(e.target).closest(SELECTORS_NOTIFICATION);this.showNotification(notificationElement.next()),data.originalEvent.preventDefault()}.bind(this)),this.getContainer().on(NotificationAreaEvents.notificationShown,function(e,notification){if(!notification.read){var element=this.getNotificationElement(notification.id);element&&this.markNotificationAsRead(element);var cachedNotification=this.getCacheNotification(notification.id);cachedNotification&&(cachedNotification.read=!0)}}.bind(this))},ControlArea}));

//# sourceMappingURL=notification_area_control_area.min.js.map