define("tiny_equation/equation",["exports","tiny_equation/selectors"],(function(_exports,_selectors){var obj;
/**
   * Equation helper for Tiny Equation plugin.
   *
   * @module      tiny_equation/equation
   * @copyright   2022 Huong Nguyen <huongnv13@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.setEquation=_exports.getSourceEquation=_exports.getSelectedEquation=_exports.getCurrentEquationData=void 0,_selectors=(obj=_selectors)&&obj.__esModule?obj:{default:obj};let sourceEquation=null;const getSourceEquation=()=>sourceEquation;_exports.getSourceEquation=getSourceEquation;const getSelectedEquation=editor=>{const currentSelection=editor.selection.getSel();if(!currentSelection)return!1;const textSelection=editor.selection.getNode().textContent,currentCaretPos=currentSelection.focusOffset;let returnValue=!1;return _selectors.default.equationPatterns.forEach((pattern=>{const regexPattern=new RegExp(pattern.source,"g");[...textSelection.matchAll(regexPattern)].forEach((matches=>{const match=matches[0];let startIndex=0;const startOuter=textSelection.indexOf(match,startIndex),endOuter=startOuter+match.length,innerMatch=match.match(pattern);if(innerMatch&&innerMatch.length){const startInner=textSelection.indexOf(innerMatch[1],startOuter),endInner=startInner+innerMatch[1].length;if(currentCaretPos>=startOuter&&currentCaretPos<=endOuter)return returnValue=innerMatch[1],void(sourceEquation={startInnerPosition:startInner,endInnerPosition:endInner,innerMatch:innerMatch})}startIndex=endOuter}))})),!1!==returnValue?returnValue=returnValue.trim():sourceEquation=null,returnValue};_exports.getSelectedEquation=getSelectedEquation;_exports.getCurrentEquationData=editor=>{let properties={};const equation=getSelectedEquation(editor);return equation&&(properties.equation=equation),properties};_exports.setEquation=(currentForm,editor)=>{const input=currentForm.querySelector(_selectors.default.elements.equationTextArea),sourceEquation=getSourceEquation();let value=input.value;if(""!==value)if(sourceEquation){const selectedNode=editor.selection.getNode(),text=selectedNode.textContent;value=" "+value+" ",selectedNode.textContent=text.slice(0,sourceEquation.startInnerPosition)+value+text.slice(sourceEquation.endInnerPosition)}else value=_selectors.default.delimiters.start+" "+value+" "+_selectors.default.delimiters.end,editor.insertContent(value)}}));

//# sourceMappingURL=equation.min.js.map