/**!
 * @fileOverview Kickass library to create and place poppers near their reference elements.
 * @version 1.12.6
 * @license
 * Copyright (c) 2016 Federico Zivolo and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define("core/popper",factory):global.Popper=factory()}(window,(function(){for(var isBrowser="undefined"!=typeof window&&void 0!==window.document,longerTimeoutBrowsers=["Edge","Trident","Firefox"],timeoutDuration=0,i=0;i<longerTimeoutBrowsers.length;i+=1)if(isBrowser&&navigator.userAgent.indexOf(longerTimeoutBrowsers[i])>=0){timeoutDuration=1;break}var debounce=isBrowser&&window.Promise?function(fn){var called=!1;return function(){called||(called=!0,Promise.resolve().then((function(){called=!1,fn()})))}}:function(fn){var scheduled=!1;return function(){scheduled||(scheduled=!0,setTimeout((function(){scheduled=!1,fn()}),timeoutDuration))}};function isFunction(functionToCheck){return functionToCheck&&"[object Function]"==={}.toString.call(functionToCheck)}function getStyleComputedProperty(element,property){if(1!==element.nodeType)return[];var css=window.getComputedStyle(element,null);return property?css[property]:css}function getParentNode(element){return"HTML"===element.nodeName?element:element.parentNode||element.host}function getScrollParent(element){if(!element)return window.document.body;switch(element.nodeName){case"HTML":case"BODY":return element.ownerDocument.body;case"#document":return element.body}var _getStyleComputedProp=getStyleComputedProperty(element),overflow=_getStyleComputedProp.overflow,overflowX=_getStyleComputedProp.overflowX,overflowY=_getStyleComputedProp.overflowY;return/(auto|scroll)/.test(overflow+overflowY+overflowX)?element:getScrollParent(getParentNode(element))}function getOffsetParent(element){var offsetParent=element&&element.offsetParent,nodeName=offsetParent&&offsetParent.nodeName;return nodeName&&"BODY"!==nodeName&&"HTML"!==nodeName?-1!==["TD","TABLE"].indexOf(offsetParent.nodeName)&&"static"===getStyleComputedProperty(offsetParent,"position")?getOffsetParent(offsetParent):offsetParent:element?element.ownerDocument.documentElement:window.document.documentElement}function getRoot(node){return null!==node.parentNode?getRoot(node.parentNode):node}function findCommonOffsetParent(element1,element2){if(!(element1&&element1.nodeType&&element2&&element2.nodeType))return window.document.documentElement;var order=element1.compareDocumentPosition(element2)&Node.DOCUMENT_POSITION_FOLLOWING,start=order?element1:element2,end=order?element2:element1,range=document.createRange();range.setStart(start,0),range.setEnd(end,0);var element,nodeName,commonAncestorContainer=range.commonAncestorContainer;if(element1!==commonAncestorContainer&&element2!==commonAncestorContainer||start.contains(end))return"BODY"===(nodeName=(element=commonAncestorContainer).nodeName)||"HTML"!==nodeName&&getOffsetParent(element.firstElementChild)!==element?getOffsetParent(commonAncestorContainer):commonAncestorContainer;var element1root=getRoot(element1);return element1root.host?findCommonOffsetParent(element1root.host,element2):findCommonOffsetParent(element1,getRoot(element2).host)}function getScroll(element){var side=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"top",upperSide="top"===side?"scrollTop":"scrollLeft",nodeName=element.nodeName;if("BODY"===nodeName||"HTML"===nodeName){var html=element.ownerDocument.documentElement,scrollingElement=element.ownerDocument.scrollingElement||html;return scrollingElement[upperSide]}return element[upperSide]}function getBordersSize(styles,axis){var sideA="x"===axis?"Left":"Top",sideB="Left"===sideA?"Right":"Bottom";return+styles["border"+sideA+"Width"].split("px")[0]+ +styles["border"+sideB+"Width"].split("px")[0]}var isIE10=void 0,isIE10$1=function(){return void 0===isIE10&&(isIE10=-1!==navigator.appVersion.indexOf("MSIE 10")),isIE10};function getSize(axis,body,html,computedStyle){return Math.max(body["offset"+axis],body["scroll"+axis],html["client"+axis],html["offset"+axis],html["scroll"+axis],isIE10$1()?html["offset"+axis]+computedStyle["margin"+("Height"===axis?"Top":"Left")]+computedStyle["margin"+("Height"===axis?"Bottom":"Right")]:0)}function getWindowSizes(){var body=window.document.body,html=window.document.documentElement,computedStyle=isIE10$1()&&window.getComputedStyle(html);return{height:getSize("Height",body,html,computedStyle),width:getSize("Width",body,html,computedStyle)}}var classCallCheck=function(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")},createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){return protoProps&&defineProperties(Constructor.prototype,protoProps),staticProps&&defineProperties(Constructor,staticProps),Constructor}}(),defineProperty=function(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj},_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source)Object.prototype.hasOwnProperty.call(source,key)&&(target[key]=source[key])}return target};function getClientRect(offsets){return _extends({},offsets,{right:offsets.left+offsets.width,bottom:offsets.top+offsets.height})}function getBoundingClientRect(element){var rect={};if(isIE10$1())try{rect=element.getBoundingClientRect();var scrollTop=getScroll(element,"top"),scrollLeft=getScroll(element,"left");rect.top+=scrollTop,rect.left+=scrollLeft,rect.bottom+=scrollTop,rect.right+=scrollLeft}catch(err){}else rect=element.getBoundingClientRect();var result={left:rect.left,top:rect.top,width:rect.right-rect.left,height:rect.bottom-rect.top},sizes="HTML"===element.nodeName?getWindowSizes():{},width=sizes.width||element.clientWidth||result.right-result.left,height=sizes.height||element.clientHeight||result.bottom-result.top,horizScrollbar=element.offsetWidth-width,vertScrollbar=element.offsetHeight-height;if(horizScrollbar||vertScrollbar){var styles=getStyleComputedProperty(element);horizScrollbar-=getBordersSize(styles,"x"),vertScrollbar-=getBordersSize(styles,"y"),result.width-=horizScrollbar,result.height-=vertScrollbar}return getClientRect(result)}function getOffsetRectRelativeToArbitraryNode(children,parent){var isIE10=isIE10$1(),isHTML="HTML"===parent.nodeName,childrenRect=getBoundingClientRect(children),parentRect=getBoundingClientRect(parent),scrollParent=getScrollParent(children),styles=getStyleComputedProperty(parent),borderTopWidth=+styles.borderTopWidth.split("px")[0],borderLeftWidth=+styles.borderLeftWidth.split("px")[0],offsets=getClientRect({top:childrenRect.top-parentRect.top-borderTopWidth,left:childrenRect.left-parentRect.left-borderLeftWidth,width:childrenRect.width,height:childrenRect.height});if(offsets.marginTop=0,offsets.marginLeft=0,!isIE10&&isHTML){var marginTop=+styles.marginTop.split("px")[0],marginLeft=+styles.marginLeft.split("px")[0];offsets.top-=borderTopWidth-marginTop,offsets.bottom-=borderTopWidth-marginTop,offsets.left-=borderLeftWidth-marginLeft,offsets.right-=borderLeftWidth-marginLeft,offsets.marginTop=marginTop,offsets.marginLeft=marginLeft}return(isIE10?parent.contains(scrollParent):parent===scrollParent&&"BODY"!==scrollParent.nodeName)&&(offsets=function(rect,element){var subtract=arguments.length>2&&void 0!==arguments[2]&&arguments[2],scrollTop=getScroll(element,"top"),scrollLeft=getScroll(element,"left"),modifier=subtract?-1:1;return rect.top+=scrollTop*modifier,rect.bottom+=scrollTop*modifier,rect.left+=scrollLeft*modifier,rect.right+=scrollLeft*modifier,rect}(offsets,parent)),offsets}function isFixed(element){var nodeName=element.nodeName;return"BODY"!==nodeName&&"HTML"!==nodeName&&("fixed"===getStyleComputedProperty(element,"position")||isFixed(getParentNode(element)))}function getBoundaries(popper,reference,padding,boundariesElement){var boundaries={top:0,left:0},offsetParent=findCommonOffsetParent(popper,reference);if("viewport"===boundariesElement)boundaries=function(element){var html=element.ownerDocument.documentElement,relativeOffset=getOffsetRectRelativeToArbitraryNode(element,html),width=Math.max(html.clientWidth,window.innerWidth||0),height=Math.max(html.clientHeight,window.innerHeight||0),scrollTop=getScroll(html),scrollLeft=getScroll(html,"left");return getClientRect({top:scrollTop-relativeOffset.top+relativeOffset.marginTop,left:scrollLeft-relativeOffset.left+relativeOffset.marginLeft,width:width,height:height})}(offsetParent);else{var boundariesNode=void 0;"scrollParent"===boundariesElement?"BODY"===(boundariesNode=getScrollParent(getParentNode(popper))).nodeName&&(boundariesNode=popper.ownerDocument.documentElement):boundariesNode="window"===boundariesElement?popper.ownerDocument.documentElement:boundariesElement;var offsets=getOffsetRectRelativeToArbitraryNode(boundariesNode,offsetParent);if("HTML"!==boundariesNode.nodeName||isFixed(offsetParent))boundaries=offsets;else{var _getWindowSizes=getWindowSizes(),height=_getWindowSizes.height,width=_getWindowSizes.width;boundaries.top+=offsets.top-offsets.marginTop,boundaries.bottom=height+offsets.top,boundaries.left+=offsets.left-offsets.marginLeft,boundaries.right=width+offsets.left}}return boundaries.left+=padding,boundaries.top+=padding,boundaries.right-=padding,boundaries.bottom-=padding,boundaries}function getArea(_ref){return _ref.width*_ref.height}function computeAutoPlacement(placement,refRect,popper,reference,boundariesElement){var padding=arguments.length>5&&void 0!==arguments[5]?arguments[5]:0;if(-1===placement.indexOf("auto"))return placement;var boundaries=getBoundaries(popper,reference,padding,boundariesElement),rects={top:{width:boundaries.width,height:refRect.top-boundaries.top},right:{width:boundaries.right-refRect.right,height:boundaries.height},bottom:{width:boundaries.width,height:boundaries.bottom-refRect.bottom},left:{width:refRect.left-boundaries.left,height:boundaries.height}},sortedAreas=Object.keys(rects).map((function(key){return _extends({key:key},rects[key],{area:getArea(rects[key])})})).sort((function(a,b){return b.area-a.area})),filteredAreas=sortedAreas.filter((function(_ref2){var width=_ref2.width,height=_ref2.height;return width>=popper.clientWidth&&height>=popper.clientHeight})),computedPlacement=filteredAreas.length>0?filteredAreas[0].key:sortedAreas[0].key,variation=placement.split("-")[1];return computedPlacement+(variation?"-"+variation:"")}function getReferenceOffsets(state,popper,reference){return getOffsetRectRelativeToArbitraryNode(reference,findCommonOffsetParent(popper,reference))}function getOuterSizes(element){var styles=window.getComputedStyle(element),x=parseFloat(styles.marginTop)+parseFloat(styles.marginBottom),y=parseFloat(styles.marginLeft)+parseFloat(styles.marginRight);return{width:element.offsetWidth+y,height:element.offsetHeight+x}}function getOppositePlacement(placement){var hash={left:"right",right:"left",bottom:"top",top:"bottom"};return placement.replace(/left|right|bottom|top/g,(function(matched){return hash[matched]}))}function getPopperOffsets(popper,referenceOffsets,placement){placement=placement.split("-")[0];var popperRect=getOuterSizes(popper),popperOffsets={width:popperRect.width,height:popperRect.height},isHoriz=-1!==["right","left"].indexOf(placement),mainSide=isHoriz?"top":"left",secondarySide=isHoriz?"left":"top",measurement=isHoriz?"height":"width",secondaryMeasurement=isHoriz?"width":"height";return popperOffsets[mainSide]=referenceOffsets[mainSide]+referenceOffsets[measurement]/2-popperRect[measurement]/2,popperOffsets[secondarySide]=placement===secondarySide?referenceOffsets[secondarySide]-popperRect[secondaryMeasurement]:referenceOffsets[getOppositePlacement(secondarySide)],popperOffsets}function find(arr,check){return Array.prototype.find?arr.find(check):arr.filter(check)[0]}function runModifiers(modifiers,data,ends){return(void 0===ends?modifiers:modifiers.slice(0,function(arr,prop,value){if(Array.prototype.findIndex)return arr.findIndex((function(cur){return cur[prop]===value}));var match=find(arr,(function(obj){return obj[prop]===value}));return arr.indexOf(match)}(modifiers,"name",ends))).forEach((function(modifier){modifier.function&&console.warn("`modifier.function` is deprecated, use `modifier.fn`!");var fn=modifier.function||modifier.fn;modifier.enabled&&isFunction(fn)&&(data.offsets.popper=getClientRect(data.offsets.popper),data.offsets.reference=getClientRect(data.offsets.reference),data=fn(data,modifier))})),data}function update(){if(!this.state.isDestroyed){var data={instance:this,styles:{},arrowStyles:{},attributes:{},flipped:!1,offsets:{}};data.offsets.reference=getReferenceOffsets(this.state,this.popper,this.reference),data.placement=computeAutoPlacement(this.options.placement,data.offsets.reference,this.popper,this.reference,this.options.modifiers.flip.boundariesElement,this.options.modifiers.flip.padding),data.originalPlacement=data.placement,data.offsets.popper=getPopperOffsets(this.popper,data.offsets.reference,data.placement),data.offsets.popper.position="absolute",data=runModifiers(this.modifiers,data),this.state.isCreated?this.options.onUpdate(data):(this.state.isCreated=!0,this.options.onCreate(data))}}function isModifierEnabled(modifiers,modifierName){return modifiers.some((function(_ref){var name=_ref.name;return _ref.enabled&&name===modifierName}))}function getSupportedPropertyName(property){for(var prefixes=[!1,"ms","Webkit","Moz","O"],upperProp=property.charAt(0).toUpperCase()+property.slice(1),i=0;i<prefixes.length-1;i++){var prefix=prefixes[i],toCheck=prefix?""+prefix+upperProp:property;if(void 0!==window.document.body.style[toCheck])return toCheck}return null}function destroy(){return this.state.isDestroyed=!0,isModifierEnabled(this.modifiers,"applyStyle")&&(this.popper.removeAttribute("x-placement"),this.popper.style.left="",this.popper.style.position="",this.popper.style.top="",this.popper.style[getSupportedPropertyName("transform")]=""),this.disableEventListeners(),this.options.removeOnDestroy&&this.popper.parentNode.removeChild(this.popper),this}function getWindow(element){var ownerDocument=element.ownerDocument;return ownerDocument?ownerDocument.defaultView:window}function attachToScrollParents(scrollParent,event,callback,scrollParents){var isBody="BODY"===scrollParent.nodeName,target=isBody?scrollParent.ownerDocument.defaultView:scrollParent;target.addEventListener(event,callback,{passive:!0}),isBody||attachToScrollParents(getScrollParent(target.parentNode),event,callback,scrollParents),scrollParents.push(target)}function setupEventListeners(reference,options,state,updateBound){state.updateBound=updateBound,getWindow(reference).addEventListener("resize",state.updateBound,{passive:!0});var scrollElement=getScrollParent(reference);return attachToScrollParents(scrollElement,"scroll",state.updateBound,state.scrollParents),state.scrollElement=scrollElement,state.eventsEnabled=!0,state}function enableEventListeners(){this.state.eventsEnabled||(this.state=setupEventListeners(this.reference,this.options,this.state,this.scheduleUpdate))}function disableEventListeners(){var reference,state;this.state.eventsEnabled&&(window.cancelAnimationFrame(this.scheduleUpdate),this.state=(reference=this.reference,state=this.state,getWindow(reference).removeEventListener("resize",state.updateBound),state.scrollParents.forEach((function(target){target.removeEventListener("scroll",state.updateBound)})),state.updateBound=null,state.scrollParents=[],state.scrollElement=null,state.eventsEnabled=!1,state))}function isNumeric(n){return""!==n&&!isNaN(parseFloat(n))&&isFinite(n)}function setStyles(element,styles){Object.keys(styles).forEach((function(prop){var unit="";-1!==["width","height","top","right","bottom","left"].indexOf(prop)&&isNumeric(styles[prop])&&(unit="px"),element.style[prop]=styles[prop]+unit}))}function isModifierRequired(modifiers,requestingName,requestedName){var requesting=find(modifiers,(function(_ref){return _ref.name===requestingName})),isRequired=!!requesting&&modifiers.some((function(modifier){return modifier.name===requestedName&&modifier.enabled&&modifier.order<requesting.order}));if(!isRequired){var _requesting="`"+requestingName+"`",requested="`"+requestedName+"`";console.warn(requested+" modifier is required by "+_requesting+" modifier in order to work, be sure to include it before "+_requesting+"!")}return isRequired}var placements=["auto-start","auto","auto-end","top-start","top","top-end","right-start","right","right-end","bottom-end","bottom","bottom-start","left-end","left","left-start"],validPlacements=placements.slice(3);function clockwise(placement){var counter=arguments.length>1&&void 0!==arguments[1]&&arguments[1],index=validPlacements.indexOf(placement),arr=validPlacements.slice(index+1).concat(validPlacements.slice(0,index));return counter?arr.reverse():arr}var BEHAVIORS_FLIP="flip",BEHAVIORS_CLOCKWISE="clockwise",BEHAVIORS_COUNTERCLOCKWISE="counterclockwise";function parseOffset(offset,popperOffsets,referenceOffsets,basePlacement){var offsets=[0,0],useHeight=-1!==["right","left"].indexOf(basePlacement),fragments=offset.split(/(\+|\-)/).map((function(frag){return frag.trim()})),divider=fragments.indexOf(find(fragments,(function(frag){return-1!==frag.search(/,|\s/)})));fragments[divider]&&-1===fragments[divider].indexOf(",")&&console.warn("Offsets separated by white space(s) are deprecated, use a comma (,) instead.");var splitRegex=/\s*,\s*|\s+/,ops=-1!==divider?[fragments.slice(0,divider).concat([fragments[divider].split(splitRegex)[0]]),[fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider+1))]:[fragments];return ops=ops.map((function(op,index){var measurement=(1===index?!useHeight:useHeight)?"height":"width",mergeWithPrevious=!1;return op.reduce((function(a,b){return""===a[a.length-1]&&-1!==["+","-"].indexOf(b)?(a[a.length-1]=b,mergeWithPrevious=!0,a):mergeWithPrevious?(a[a.length-1]+=b,mergeWithPrevious=!1,a):a.concat(b)}),[]).map((function(str){return function(str,measurement,popperOffsets,referenceOffsets){var split=str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/),value=+split[1],unit=split[2];if(!value)return str;if(0===unit.indexOf("%")){return getClientRect("%p"===unit?popperOffsets:referenceOffsets)[measurement]/100*value}if("vh"===unit||"vw"===unit)return("vh"===unit?Math.max(document.documentElement.clientHeight,window.innerHeight||0):Math.max(document.documentElement.clientWidth,window.innerWidth||0))/100*value;return value}(str,measurement,popperOffsets,referenceOffsets)}))})),ops.forEach((function(op,index){op.forEach((function(frag,index2){isNumeric(frag)&&(offsets[index]+=frag*("-"===op[index2-1]?-1:1))}))})),offsets}var modifiers={shift:{order:100,enabled:!0,fn:function(data){var placement=data.placement,basePlacement=placement.split("-")[0],shiftvariation=placement.split("-")[1];if(shiftvariation){var _data$offsets=data.offsets,reference=_data$offsets.reference,popper=_data$offsets.popper,isVertical=-1!==["bottom","top"].indexOf(basePlacement),side=isVertical?"left":"top",measurement=isVertical?"width":"height",shiftOffsets={start:defineProperty({},side,reference[side]),end:defineProperty({},side,reference[side]+reference[measurement]-popper[measurement])};data.offsets.popper=_extends({},popper,shiftOffsets[shiftvariation])}return data}},offset:{order:200,enabled:!0,fn:function(data,_ref){var offset=_ref.offset,placement=data.placement,_data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference,basePlacement=placement.split("-")[0],offsets=void 0;return offsets=isNumeric(+offset)?[+offset,0]:parseOffset(offset,popper,reference,basePlacement),"left"===basePlacement?(popper.top+=offsets[0],popper.left-=offsets[1]):"right"===basePlacement?(popper.top+=offsets[0],popper.left+=offsets[1]):"top"===basePlacement?(popper.left+=offsets[0],popper.top-=offsets[1]):"bottom"===basePlacement&&(popper.left+=offsets[0],popper.top+=offsets[1]),data.popper=popper,data},offset:0},preventOverflow:{order:300,enabled:!0,fn:function(data,options){var boundariesElement=options.boundariesElement||getOffsetParent(data.instance.popper);data.instance.reference===boundariesElement&&(boundariesElement=getOffsetParent(boundariesElement));var boundaries=getBoundaries(data.instance.popper,data.instance.reference,options.padding,boundariesElement);options.boundaries=boundaries;var order=options.priority,popper=data.offsets.popper,check={primary:function(placement){var value=popper[placement];return popper[placement]<boundaries[placement]&&!options.escapeWithReference&&(value=Math.max(popper[placement],boundaries[placement])),defineProperty({},placement,value)},secondary:function(placement){var mainSide="right"===placement?"left":"top",value=popper[mainSide];return popper[placement]>boundaries[placement]&&!options.escapeWithReference&&(value=Math.min(popper[mainSide],boundaries[placement]-("right"===placement?popper.width:popper.height))),defineProperty({},mainSide,value)}};return order.forEach((function(placement){var side=-1!==["left","top"].indexOf(placement)?"primary":"secondary";popper=_extends({},popper,check[side](placement))})),data.offsets.popper=popper,data},priority:["left","right","top","bottom"],padding:5,boundariesElement:"scrollParent"},keepTogether:{order:400,enabled:!0,fn:function(data){var _data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference,placement=data.placement.split("-")[0],floor=Math.floor,isVertical=-1!==["top","bottom"].indexOf(placement),side=isVertical?"right":"bottom",opSide=isVertical?"left":"top",measurement=isVertical?"width":"height";return popper[side]<floor(reference[opSide])&&(data.offsets.popper[opSide]=floor(reference[opSide])-popper[measurement]),popper[opSide]>floor(reference[side])&&(data.offsets.popper[opSide]=floor(reference[side])),data}},arrow:{order:500,enabled:!0,fn:function(data,options){if(!isModifierRequired(data.instance.modifiers,"arrow","keepTogether"))return data;var arrowElement=options.element;if("string"==typeof arrowElement){if(!(arrowElement=data.instance.popper.querySelector(arrowElement)))return data}else if(!data.instance.popper.contains(arrowElement))return console.warn("WARNING: `arrow.element` must be child of its popper element!"),data;var placement=data.placement.split("-")[0],_data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference,isVertical=-1!==["left","right"].indexOf(placement),len=isVertical?"height":"width",sideCapitalized=isVertical?"Top":"Left",side=sideCapitalized.toLowerCase(),altSide=isVertical?"left":"top",opSide=isVertical?"bottom":"right",arrowElementSize=getOuterSizes(arrowElement)[len];reference[opSide]-arrowElementSize<popper[side]&&(data.offsets.popper[side]-=popper[side]-(reference[opSide]-arrowElementSize)),reference[side]+arrowElementSize>popper[opSide]&&(data.offsets.popper[side]+=reference[side]+arrowElementSize-popper[opSide]);var center=reference[side]+reference[len]/2-arrowElementSize/2,popperMarginSide=getStyleComputedProperty(data.instance.popper,"margin"+sideCapitalized).replace("px",""),sideValue=center-getClientRect(data.offsets.popper)[side]-popperMarginSide;return sideValue=Math.max(Math.min(popper[len]-arrowElementSize,sideValue),0),data.arrowElement=arrowElement,data.offsets.arrow={},data.offsets.arrow[side]=Math.round(sideValue),data.offsets.arrow[altSide]="",data},element:"[x-arrow]"},flip:{order:600,enabled:!0,fn:function(data,options){if(isModifierEnabled(data.instance.modifiers,"inner"))return data;if(data.flipped&&data.placement===data.originalPlacement)return data;var boundaries=getBoundaries(data.instance.popper,data.instance.reference,options.padding,options.boundariesElement),placement=data.placement.split("-")[0],placementOpposite=getOppositePlacement(placement),variation=data.placement.split("-")[1]||"",flipOrder=[];switch(options.behavior){case BEHAVIORS_FLIP:flipOrder=[placement,placementOpposite];break;case BEHAVIORS_CLOCKWISE:flipOrder=clockwise(placement);break;case BEHAVIORS_COUNTERCLOCKWISE:flipOrder=clockwise(placement,!0);break;default:flipOrder=options.behavior}return flipOrder.forEach((function(step,index){if(placement!==step||flipOrder.length===index+1)return data;placement=data.placement.split("-")[0],placementOpposite=getOppositePlacement(placement);var popperOffsets=data.offsets.popper,refOffsets=data.offsets.reference,floor=Math.floor,overlapsRef="left"===placement&&floor(popperOffsets.right)>floor(refOffsets.left)||"right"===placement&&floor(popperOffsets.left)<floor(refOffsets.right)||"top"===placement&&floor(popperOffsets.bottom)>floor(refOffsets.top)||"bottom"===placement&&floor(popperOffsets.top)<floor(refOffsets.bottom),overflowsLeft=floor(popperOffsets.left)<floor(boundaries.left),overflowsRight=floor(popperOffsets.right)>floor(boundaries.right),overflowsTop=floor(popperOffsets.top)<floor(boundaries.top),overflowsBottom=floor(popperOffsets.bottom)>floor(boundaries.bottom),overflowsBoundaries="left"===placement&&overflowsLeft||"right"===placement&&overflowsRight||"top"===placement&&overflowsTop||"bottom"===placement&&overflowsBottom,isVertical=-1!==["top","bottom"].indexOf(placement),flippedVariation=!!options.flipVariations&&(isVertical&&"start"===variation&&overflowsLeft||isVertical&&"end"===variation&&overflowsRight||!isVertical&&"start"===variation&&overflowsTop||!isVertical&&"end"===variation&&overflowsBottom);(overlapsRef||overflowsBoundaries||flippedVariation)&&(data.flipped=!0,(overlapsRef||overflowsBoundaries)&&(placement=flipOrder[index+1]),flippedVariation&&(variation=function(variation){return"end"===variation?"start":"start"===variation?"end":variation}(variation)),data.placement=placement+(variation?"-"+variation:""),data.offsets.popper=_extends({},data.offsets.popper,getPopperOffsets(data.instance.popper,data.offsets.reference,data.placement)),data=runModifiers(data.instance.modifiers,data,"flip"))})),data},behavior:"flip",padding:5,boundariesElement:"viewport"},inner:{order:700,enabled:!1,fn:function(data){var placement=data.placement,basePlacement=placement.split("-")[0],_data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference,isHoriz=-1!==["left","right"].indexOf(basePlacement),subtractLength=-1===["top","left"].indexOf(basePlacement);return popper[isHoriz?"left":"top"]=reference[basePlacement]-(subtractLength?popper[isHoriz?"width":"height"]:0),data.placement=getOppositePlacement(placement),data.offsets.popper=getClientRect(popper),data}},hide:{order:800,enabled:!0,fn:function(data){if(!isModifierRequired(data.instance.modifiers,"hide","preventOverflow"))return data;var refRect=data.offsets.reference,bound=find(data.instance.modifiers,(function(modifier){return"preventOverflow"===modifier.name})).boundaries;if(refRect.bottom<bound.top||refRect.left>bound.right||refRect.top>bound.bottom||refRect.right<bound.left){if(!0===data.hide)return data;data.hide=!0,data.attributes["x-out-of-boundaries"]=""}else{if(!1===data.hide)return data;data.hide=!1,data.attributes["x-out-of-boundaries"]=!1}return data}},computeStyle:{order:850,enabled:!0,fn:function(data,options){var x=options.x,y=options.y,popper=data.offsets.popper,legacyGpuAccelerationOption=find(data.instance.modifiers,(function(modifier){return"applyStyle"===modifier.name})).gpuAcceleration;void 0!==legacyGpuAccelerationOption&&console.warn("WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!");var gpuAcceleration=void 0!==legacyGpuAccelerationOption?legacyGpuAccelerationOption:options.gpuAcceleration,offsetParentRect=getBoundingClientRect(getOffsetParent(data.instance.popper)),styles={position:popper.position},offsets={left:Math.floor(popper.left),top:Math.floor(popper.top),bottom:Math.floor(popper.bottom),right:Math.floor(popper.right)},sideA="bottom"===x?"top":"bottom",sideB="right"===y?"left":"right",prefixedProperty=getSupportedPropertyName("transform"),left=void 0,top=void 0;if(top="bottom"===sideA?-offsetParentRect.height+offsets.bottom:offsets.top,left="right"===sideB?-offsetParentRect.width+offsets.right:offsets.left,gpuAcceleration&&prefixedProperty)styles[prefixedProperty]="translate3d("+left+"px, "+top+"px, 0)",styles[sideA]=0,styles[sideB]=0,styles.willChange="transform";else{var invertTop="bottom"===sideA?-1:1,invertLeft="right"===sideB?-1:1;styles[sideA]=top*invertTop,styles[sideB]=left*invertLeft,styles.willChange=sideA+", "+sideB}var attributes={"x-placement":data.placement};return data.attributes=_extends({},attributes,data.attributes),data.styles=_extends({},styles,data.styles),data.arrowStyles=_extends({},data.offsets.arrow,data.arrowStyles),data},gpuAcceleration:!0,x:"bottom",y:"right"},applyStyle:{order:900,enabled:!0,fn:function(data){var element,attributes;return setStyles(data.instance.popper,data.styles),element=data.instance.popper,attributes=data.attributes,Object.keys(attributes).forEach((function(prop){!1!==attributes[prop]?element.setAttribute(prop,attributes[prop]):element.removeAttribute(prop)})),data.arrowElement&&Object.keys(data.arrowStyles).length&&setStyles(data.arrowElement,data.arrowStyles),data},onLoad:function(reference,popper,options,modifierOptions,state){var referenceOffsets=getReferenceOffsets(0,popper,reference),placement=computeAutoPlacement(options.placement,referenceOffsets,popper,reference,options.modifiers.flip.boundariesElement,options.modifiers.flip.padding);return popper.setAttribute("x-placement",placement),setStyles(popper,{position:"absolute"}),options},gpuAcceleration:void 0}},Defaults={placement:"bottom",eventsEnabled:!0,removeOnDestroy:!1,onCreate:function(){},onUpdate:function(){},modifiers:modifiers},Popper=function(){function Popper(reference,popper){var _this=this,options=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};classCallCheck(this,Popper),this.scheduleUpdate=function(){return requestAnimationFrame(_this.update)},this.update=debounce(this.update.bind(this)),this.options=_extends({},Popper.Defaults,options),this.state={isDestroyed:!1,isCreated:!1,scrollParents:[]},this.reference=reference&&reference.jquery?reference[0]:reference,this.popper=popper&&popper.jquery?popper[0]:popper,this.options.modifiers={},Object.keys(_extends({},Popper.Defaults.modifiers,options.modifiers)).forEach((function(name){_this.options.modifiers[name]=_extends({},Popper.Defaults.modifiers[name]||{},options.modifiers?options.modifiers[name]:{})})),this.modifiers=Object.keys(this.options.modifiers).map((function(name){return _extends({name:name},_this.options.modifiers[name])})).sort((function(a,b){return a.order-b.order})),this.modifiers.forEach((function(modifierOptions){modifierOptions.enabled&&isFunction(modifierOptions.onLoad)&&modifierOptions.onLoad(_this.reference,_this.popper,_this.options,modifierOptions,_this.state)})),this.update();var eventsEnabled=this.options.eventsEnabled;eventsEnabled&&this.enableEventListeners(),this.state.eventsEnabled=eventsEnabled}return createClass(Popper,[{key:"update",value:function(){return update.call(this)}},{key:"destroy",value:function(){return destroy.call(this)}},{key:"enableEventListeners",value:function(){return enableEventListeners.call(this)}},{key:"disableEventListeners",value:function(){return disableEventListeners.call(this)}}]),Popper}();return Popper.Utils=("undefined"!=typeof window?window:global).PopperUtils,Popper.placements=placements,Popper.Defaults=Defaults,Popper}));

//# sourceMappingURL=popper.min.js.map