/**
 * Chart axis.
 *
 * @module core/chart_axis
 * @copyright  2016 Frédéric Massart - FMCorz.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/chart_axis",[],(function(){function Axis(){}return Axis.prototype.POS_DEFAULT=null,Axis.prototype.POS_BOTTOM="bottom",Axis.prototype.POS_LEFT="left",Axis.prototype.POS_RIGHT="right",Axis.prototype.POS_TOP="top",Axis.prototype._label=null,Axis.prototype._labels=null,Axis.prototype._max=null,Axis.prototype._min=null,Axis.prototype._position=null,Axis.prototype._stepSize=null,Axis.prototype.create=function(obj){var s=new Axis;return s.setPosition(obj.position),s.setLabel(obj.label),s.setStepSize(obj.stepSize),s.setMax(obj.max),s.setMin(obj.min),s.setLabels(obj.labels),s},Axis.prototype.getLabel=function(){return this._label},Axis.prototype.getLabels=function(){return this._labels},Axis.prototype.getMax=function(){return this._max},Axis.prototype.getMin=function(){return this._min},Axis.prototype.getPosition=function(){return this._position},Axis.prototype.getStepSize=function(){return this._stepSize},Axis.prototype.setLabel=function(label){this._label=label||null},Axis.prototype.setLabels=function(labels){this._labels=labels||null,null===this._labels||null!==this._stepSize||null!==this._min&&0!==this._min||null!==this._max||(this.setStepSize(1),this.setMin(0),this.setMax(labels.length-1))},Axis.prototype.setMax=function(max){this._max=void 0!==max?max:null},Axis.prototype.setMin=function(min){this._min=void 0!==min?min:null},Axis.prototype.setPosition=function(position){if(position!=this.POS_DEFAULT&&position!=this.POS_BOTTOM&&position!=this.POS_LEFT&&position!=this.POS_RIGHT&&position!=this.POS_TOP)throw new Error("Invalid axis position.");this._position=position},Axis.prototype.setStepSize=function(stepSize){if(null==stepSize)stepSize=null;else{if(isNaN(Number(stepSize)))throw new Error("Value for stepSize is not a number.");stepSize=Number(stepSize)}this._stepSize=stepSize},Axis}));

//# sourceMappingURL=chart_axis.min.js.map